﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Web;
using System.Xml;
using System.Text;

namespace MedeilMVC_CLOUD.Database_Access_Layer
{
    public class GetLocation
    {

        #region Private Properties
        private string latitude = string.Empty;
        private string longitude = string.Empty;
        #endregion

        #region Public Properties
        public string Longitude
        {
            get { return longitude; }
            set { longitude = value; }
        }
        public string Latitude
        {
            get { return latitude; }
            set { latitude = value; }
        }

        #endregion


        public void GetGeoLocation(string url)
        {
            HttpWebRequest myHttpWebRequest = null;     //Declare an HTTP-specific implementation of the WebRequest class.
            HttpWebResponse myHttpWebResponse = null;   //Declare an HTTP-specific implementation of the WebResponse class
            XmlDocument myXMLDocument = null;           //Declare XMLResponse document
            XmlTextReader myXMLReader = null;           //Declare XMLReader
            try
            {
                //Create Request
                myHttpWebRequest = (HttpWebRequest)HttpWebRequest.Create(url);
                myHttpWebRequest.Method = "GET";
                myHttpWebRequest.ContentType = "text/xml; encoding='utf-8'";

                //Get Response
                myHttpWebResponse = (HttpWebResponse)myHttpWebRequest.GetResponse();

                //Now load the XML Document
                myXMLDocument = new XmlDocument();

                //Load response stream into XMLReader
                myXMLReader = new XmlTextReader(myHttpWebResponse.GetResponseStream());
                myXMLDocument.Load(myXMLReader);

                XmlElement root = myXMLDocument.DocumentElement;
                //XmlNodeList nodes = root.SelectNodes("//query/regionName");
                //foreach (XmlNode node in nodes)
                //{
                //    Latitude = Convert.ToString(node.InnerXml);
                //    this.Latitude = ReplaceReservedChars(Latitude);
                //}
                XmlNodeList nodesLatitude = root.SelectNodes("//query/lat");
                foreach (XmlNode node in nodesLatitude)
                {
                    string Latitude = Convert.ToString(node.InnerXml);
                    this.Latitude = ReplaceReservedChars(Latitude);

                }
                XmlNodeList nodesLongitude = root.SelectNodes("//query/lon");
                foreach (XmlNode node in nodesLongitude)
                {
                    string Longitude = Convert.ToString(node.InnerXml);
                    this.Longitude = ReplaceReservedChars(Longitude);

                }
            }
            catch (Exception ex)
            {
                //throw new Exception("Error Occurred in AuditAdapter.getXMLDocumentFromXMLTemplate()", myException);
            }

        }

        public string ReplaceReservedChars(string strValue)
        {
            char[] ReservedChars = { '/', ':', '*', '?', '"', '<', '>', '|', '!', '@', '#', '$', '%', '^', '&', '(', ')', '{', '}', '[', ']', '\\', ';', '+', '-', '_', '=', '~', '`' };

            foreach (char strChar in ReservedChars)
            {
                strValue = strValue.Replace(strChar.ToString(), string.Empty);
            }
            var trimstring = new StringBuilder(strValue);
            trimstring.Remove(0, 5);
            strValue = trimstring.ToString();
            return strValue;
        }

    }



}