﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Web;
using System.Xml;
using System.Text;

namespace MedeilMVC_CLOUD.Database_Access_Layer
{
    public class GetCity
    {
        #region Private Properties
        private string Location = string.Empty;
        private string city = string.Empty;
        private string state = string.Empty;
        private string country = string.Empty;
        private string trim = string.Empty;
        #endregion

        #region Public Properties
        public string City
        {
            get { return city; }
            set { city = value; }
        }
        public string State
        {
            get { return state; }
            set { state = value; }
        }
        public string Country
        {
            get { return country; }
            set { country = value; }
        }

        #endregion


        public  void GetGeoCity(string url)
        {
            HttpWebRequest myHttpWebRequest = null;     //Declare an HTTP-specific implementation of the WebRequest class.
            HttpWebResponse myHttpWebResponse = null;   //Declare an HTTP-specific implementation of the WebResponse class
            XmlDocument myXMLDocument = null;           //Declare XMLResponse document
            XmlTextReader myXMLReader = null;           //Declare XMLReader
            try
            {
                //Create Request
                myHttpWebRequest = (HttpWebRequest)HttpWebRequest.Create(url);
                myHttpWebRequest.Method = "GET";
                myHttpWebRequest.ContentType = "text/xml; encoding='utf-8'";

                //Get Response
                myHttpWebResponse = (HttpWebResponse)myHttpWebRequest.GetResponse();

                //Now load the XML Document
                myXMLDocument = new XmlDocument();

                //Load response stream into XMLReader
                myXMLReader = new XmlTextReader(myHttpWebResponse.GetResponseStream());
                myXMLDocument.Load(myXMLReader);



                XmlElement root = myXMLDocument.DocumentElement;
                XmlNodeList nodes = root.SelectNodes("//query/regionName");
                foreach (XmlNode node in nodes)
                {
                    Location = Convert.ToString(node.InnerXml);
                    this.state = ReplaceReservedChars(Location);
                }
                XmlNodeList nodescountry = root.SelectNodes("//query/city");
                foreach (XmlNode node in nodescountry)
                {
                    string country = Convert.ToString(node.InnerXml);
                    this.city = ReplaceReservedChars(country);

                }
                XmlNodeList nodescity = root.SelectNodes("//query/country");
                foreach (XmlNode node in nodescity)
                {
                    string city = Convert.ToString(node.InnerXml);
                    this.country = ReplaceReservedChars(city);
                   
                }
            }
            catch (Exception ex)
            {
                //throw new Exception("Error Occurred in AuditAdapter.getXMLDocumentFromXMLTemplate()", myException);
            }

        }

        public  string ReplaceReservedChars(string strValue)
        {
            char[] ReservedChars = { '/', ':', '*', '?', '"', '<', '>', '|', '!', '@', '#', '$', '%', '^', '&', '(', ')', '{', '}', '[', ']', '\\', ';', '.', '+', '-', '_', '=', '~', '`' };

            foreach (char strChar in ReservedChars)
            {
                strValue = strValue.Replace(strChar.ToString(), string.Empty);
            }
            var trimstring = new StringBuilder(strValue);
            trimstring.Remove(0, 5);
            strValue = trimstring.ToString();
            return strValue;
        }
    }
}