﻿using MedeilMVC_CLOUD.Database_Access_Layer;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Configuration;
using System.Data;
using System.Data.Entity;
using System.Data.SqlClient;
using System.Linq;
using System.Web;

namespace CRM_MVC.Models
{
    public class AccountContext : DbContext
    {
        public AccountContext() : base("Admin") { }
        public DbSet<Domain> domain { get; set; }

        public DbSet<IconMaster> iconMaster { get; set; }
    }

    #region User Modules
    [Table("UserModules")]
    public class UserModules
    {
        [Key]
        public int AdminID { get; set; }
        [Display(Name = "ModuleID")]
        [Required(ErrorMessage = " Choose Module ID")]
        public int ModuleID { get; set; }
        [Display(Name = "SubModuleID")]
        [Required(ErrorMessage = " Choose SubModule ID")]

        public string DomainName { get; set; }
        public int ParentModuleID { get; set; }

        public string ModuleName { get; set; }
        public string Url { get; set; }
        public string IconName { get; set; }
        public string ClassName { get; set; }

    }

    #endregion


    #region Login
    public class Login
    {
        [Required]
        [Display(Name = "User name")]
        public string UserName { get; set; }
        [Required]
        [DataType(DataType.Password)]
        [Display(Name = "Password")]
        public string Password { get; set; }
    }




    #region CheckUserName
    public class checkuser
    {
        #region Check UserName
        public bool checkUserDetails(Login login) //This method check the user existence
        {
            bool flag = false;
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                conn.Open();
                SqlCommand cmd = new SqlCommand("Select count(*) from AdminLogin where UserName='" + login.UserName + "' and Password='" + login.Password + "'", conn);
                flag = Convert.ToBoolean(cmd.ExecuteScalar());
                return flag;
            }
        }
        #endregion

        #region get UserID_By_UserName
        public string GetUserID_By_UserName(string UserName)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("Usp_UserIDbyUserName", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@UserName", UserName);
            con.Open();
            int newID = Convert.ToInt32(cmd.ExecuteScalar());
            con.Close();
            if (newID >= 1)
            {
                return newID.ToString();
            }
            else
            {
                return "0";
            }
        }
        #endregion

        #region get UserID_By_UserName
        public string GetUserID_By_IsActive(string UserName)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("Usp_UserID_By_IsActive", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@UserName", UserName);
            con.Open();
            string newID = Convert.ToString(cmd.ExecuteScalar());
            return newID;
        }
        #endregion


        
        #region Menu Permission
        public List<UserModules> LoadPagePermissions(int AdminID)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<UserModules> PermissionsList = new List<UserModules>();
                SqlCommand com = new SqlCommand("User_PagePermissions", conn);
                com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@AdminID", AdminID);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    PermissionsList.Add(

                        new UserModules
                        {
                            ModuleID = Convert.ToInt32(dr["ModuleID"]),
                            IconName = Convert.ToString(dr["IconName"]),
                            ClassName = Convert.ToString(dr["ClassName"]),
                            DomainName = Convert.ToString(dr["DomainName"]),
                            ModuleName = Convert.ToString(dr["ModuleName"]),
                            ParentModuleID = Convert.ToInt32(dr["ParentModuleID"]),
                            Url = Convert.ToString(dr["Url"]),
                        }
                    );
                }

                return PermissionsList;
            }
        }
    }
    #endregion



    #endregion

    #endregion

    #region  AdminLogin

    [Table("AdminLogin")]
    public class AdminLogin
    {
        [Key]
        public int AdminID { get; set; }
        [Display(Name = "UserName")]
        [Required(ErrorMessage = "Enter UserName")]
        public string UserName { get; set; }
        [Display(Name = "Password")]
        [Required(ErrorMessage = "Enter Password")]
        public string Password { get; set; }
        [Display(Name = "FirstName")]
        [Required(ErrorMessage = "Enter FirstName")]
        public string FirstName { get; set; }
        public string LastName { get; set; }
        [Display(Name = "EmployeeCode")]
        [Required(ErrorMessage = "Enter EmployeeCode")]
        public string EmployeeCode { get; set; }
        public string Email { get; set; }
        public DateTime DOB { get; set; }
        [Display(Name = "Gender")]
        [Required(ErrorMessage = "Choose Gender")]
        public string Gender { get; set; }
        public DateTime DOJ { get; set; }
        public string Address1 { get; set; }
        public string Address2 { get; set; }
        public string City { get; set; }
        public string State { get; set; }
        public string Country { get; set; }
        public string PinCode { get; set; }
        public string MobileNo { get; set; }
        [Display(Name = "IsAdmin")]
        [Required(ErrorMessage = "Choose IsAdmin")]
        public string IsAdmin { get; set; }
        [Display(Name = "IsActive")]
        [Required(ErrorMessage = "Choose IsActive")]
        public string IsActive { get; set; }
        public int CreatedBy { get; set; }
        public DateTime CreatedDate = DateTime.UtcNow;
        public int ModifiedBy { get; set; }
        public DateTime ModifiedDate = DateTime.UtcNow;
        public DateTime LastAccessDate = DateTime.UtcNow;
        public string LastVisitIP { get; set; }
        public string LastVisitLocation { get; set; }

        public string Name { get; set; }
        public IEnumerable<AdminLogin> adminLogin { get; set; }
    }

    #endregion

    #region Add New User
    public class AddNewUser
    {
        #region Adduser
        public int AddNewUserReg(AdminLogin admin, int adminID)
        {
            GetCity oLoc = new GetCity();
            string url = string.Empty;
            string MyIP = string.Empty;
            //MyIP = System.Web.HttpContext.Current.Request.UserHostAddress;
            MyIP = "49.206.126.109";
            url = "http://ip-api.com/xml/" + MyIP + "";

            oLoc.GetGeoCity(url);

            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("AdminLogin_Insert", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@UserName", admin.UserName);
            cmd.Parameters.AddWithValue("@Password", admin.Password);
            cmd.Parameters.AddWithValue("@FirstName", admin.FirstName);
            cmd.Parameters.AddWithValue("@LastName", admin.LastName);
            cmd.Parameters.AddWithValue("@EmployeeCode", admin.EmployeeCode);
            cmd.Parameters.AddWithValue("@Email", admin.Email);
            cmd.Parameters.AddWithValue("@DOB", admin.DOB);
            cmd.Parameters.AddWithValue("@Gender", admin.Gender);
            cmd.Parameters.AddWithValue("@DOJ", admin.DOJ);
            cmd.Parameters.AddWithValue("@Address1", admin.Address1);
            cmd.Parameters.AddWithValue("@Address2", admin.Address2);
            cmd.Parameters.AddWithValue("@City", admin.City);
            cmd.Parameters.AddWithValue("@State", admin.State);
            cmd.Parameters.AddWithValue("@Country", admin.Country);
            cmd.Parameters.AddWithValue("@PinCode", admin.PinCode);
            cmd.Parameters.AddWithValue("@MobileNo", admin.MobileNo);
            cmd.Parameters.AddWithValue("@IsAdmin", admin.IsAdmin);
            cmd.Parameters.AddWithValue("@IsActive", admin.IsActive);
            cmd.Parameters.AddWithValue("@CreatedBy", adminID);
            cmd.Parameters.AddWithValue("@CreatedDate", admin.CreatedDate);
            cmd.Parameters.AddWithValue("@ModifiedBy", adminID);
            cmd.Parameters.AddWithValue("@ModifiedDate", admin.ModifiedDate);
            cmd.Parameters.AddWithValue("@LastAccessDate", admin.LastAccessDate);
            cmd.Parameters.AddWithValue("@LastVisitIP", MyIP);
            cmd.Parameters.AddWithValue("@LastVisitLocation", oLoc.City);
            con.Open();
            int newID = Convert.ToInt32(cmd.ExecuteScalar());
            con.Close();
            if (newID >= 1)
            {
                return newID;
            }
            else
            {
                return 0;
            }
        }

        #endregion

        #region Viewuser
        public List<AdminLogin> GetUser()
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<AdminLogin> MasterList = new List<AdminLogin>();
                SqlCommand com = new SqlCommand("GetAllUser", conn);
                com.CommandType = CommandType.StoredProcedure;
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    MasterList.Add(

                        new AdminLogin
                        {
                            AdminID = Convert.ToInt32(dr["AdminID"]),
                            UserName = Convert.ToString(dr["UserName"]),
                            Name = Convert.ToString(dr["Name"]),
                            EmployeeCode = Convert.ToString(dr["EmployeeCode"]),
                            IsAdmin = Convert.ToString(dr["IsAdmin"]),
                            IsActive = Convert.ToString(dr["IsActive"]),
                            CreatedDate = Convert.ToDateTime(dr["CreatedDate"]),
                        }
                    );
                }

                return MasterList;
            }
        }

        #endregion

        #region Edit User
        public List<AdminLogin> GetEditUser(int AdminID)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<AdminLogin> EmpList = new List<AdminLogin>();
                SqlCommand com = new SqlCommand("Usermaster_Edit", conn);
                com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@AdminID", AdminID);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new AdminLogin
                        {
                            AdminID = Convert.ToInt32(dr["AdminID"]),
                            UserName = Convert.ToString(dr["UserName"]),
                            Password = Convert.ToString(dr["Password"]),
                            FirstName = Convert.ToString(dr["FirstName"]),
                            LastName = Convert.ToString(dr["LastName"] == DBNull.Value ? null : dr["LastName"].ToString()),
                            EmployeeCode = Convert.ToString(dr["EmployeeCode"] == DBNull.Value ? null : dr["EmployeeCode"].ToString()),
                            Email = Convert.ToString(dr["Email"] == DBNull.Value ? null : dr["Email"].ToString()),
                            DOB = Convert.ToDateTime(dr["DOB"] == DBNull.Value ? null : dr["DOB"].ToString()),
                            Gender = Convert.ToString(dr["Gender"] == DBNull.Value ? null : dr["Gender"].ToString()),
                            DOJ = Convert.ToDateTime(dr["DOJ"] == DBNull.Value ? null : dr["DOJ"].ToString()),
                            Address1 = Convert.ToString(dr["Address1"] == DBNull.Value ? null : dr["Address1"].ToString()),
                            Address2 = Convert.ToString(dr["Address2"] == DBNull.Value ? null : dr["Address2"].ToString()),
                            City = Convert.ToString(dr["City"] == DBNull.Value ? null : dr["City"].ToString()),
                            State = Convert.ToString(dr["State"] == DBNull.Value ? null : dr["State"].ToString()),
                            Country = Convert.ToString(dr["Country"] == DBNull.Value ? null : dr["Country"].ToString()),
                            PinCode = Convert.ToString(dr["PinCode"] == DBNull.Value ? null : dr["PinCode"].ToString()),
                            MobileNo = Convert.ToString(dr["MobileNo"] == DBNull.Value ? null : dr["MobileNo"].ToString()),
                            IsAdmin = Convert.ToString(dr["IsAdmin"] == DBNull.Value ? null : dr["IsAdmin"].ToString()),
                            IsActive = Convert.ToString(dr["IsActive"] == DBNull.Value ? null : dr["IsActive"].ToString()),
                            CreatedBy = Convert.ToInt32(dr["CreatedBy"] == DBNull.Value ? null : dr["CreatedBy"].ToString()),
                            CreatedDate = Convert.ToDateTime(dr["CreatedDate"] == DBNull.Value ? null : dr["CreatedDate"].ToString()),
                            ModifiedBy = Convert.ToInt32(dr["ModifiedBy"] == DBNull.Value ? null : dr["ModifiedBy"].ToString()),
                            ModifiedDate = Convert.ToDateTime(dr["ModifiedDate"] == DBNull.Value ? null : dr["ModifiedDate"].ToString()),
                            LastAccessDate = Convert.ToDateTime(dr["LastAccessDate"] == DBNull.Value ? null : dr["LastAccessDate"].ToString()),
                            LastVisitIP = Convert.ToString(dr["LastVisitIP"] == DBNull.Value ? null : dr["LastVisitIP"].ToString()),
                            LastVisitLocation = Convert.ToString(dr["LastVisitLocation"] == DBNull.Value ? null : dr["LastVisitLocation"].ToString()),
                        }
                    );
                }

                return EmpList;
            }
        }
        #endregion

        #region Update User
        public bool UpdateUser(AdminLogin admin)
        {
            GetCity oLoc = new GetCity();
            string url = string.Empty;
            string MyIP = string.Empty;
            //MyIP = System.Web.HttpContext.Current.Request.UserHostAddress;
            MyIP = "49.206.126.109";
            url = "http://ip-api.com/xml/" + MyIP + "";

            oLoc.GetGeoCity(url);
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("UserMaster_Update", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@AdminID", admin.AdminID);
            cmd.Parameters.AddWithValue("@UserName", admin.UserName);
            cmd.Parameters.AddWithValue("@FirstName", admin.FirstName);
            cmd.Parameters.AddWithValue("@LastName", admin.LastName);
            cmd.Parameters.AddWithValue("@EmployeeCode", admin.EmployeeCode);
            cmd.Parameters.AddWithValue("@Email", admin.Email);
            cmd.Parameters.AddWithValue("@DOB", admin.DOB);
            cmd.Parameters.AddWithValue("@Gender", admin.Gender);
            cmd.Parameters.AddWithValue("@DOJ", admin.DOJ);
            cmd.Parameters.AddWithValue("@Address1", admin.Address1);
            cmd.Parameters.AddWithValue("@Address2", admin.Address2);
            cmd.Parameters.AddWithValue("@City", admin.City);
            cmd.Parameters.AddWithValue("@State", admin.State);
            cmd.Parameters.AddWithValue("@Country", admin.Country);
            cmd.Parameters.AddWithValue("@PinCode", admin.PinCode);
            cmd.Parameters.AddWithValue("@MobileNo", admin.MobileNo);
            cmd.Parameters.AddWithValue("@IsAdmin", admin.IsAdmin);
            cmd.Parameters.AddWithValue("@IsActive", admin.IsActive);
            cmd.Parameters.AddWithValue("@CreatedBy", admin.CreatedBy);
            cmd.Parameters.AddWithValue("@CreatedDate", admin.CreatedDate);
            cmd.Parameters.AddWithValue("@ModifiedBy", admin.ModifiedBy);
            cmd.Parameters.AddWithValue("@ModifiedDate", admin.ModifiedDate);
            cmd.Parameters.AddWithValue("@LastAccessDate", admin.LastAccessDate);
            cmd.Parameters.AddWithValue("@LastVisitIP", MyIP);
            cmd.Parameters.AddWithValue("@LastVisitLocation", oLoc.City);
            con.Open();
            int i = cmd.ExecuteNonQuery();
            con.Close();
            if (i >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        #endregion

        #region Delete User
        public bool DeleteUserMaster(int AdminID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("UserMaster_Delete", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@AdminID", AdminID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        #endregion
    }
    #endregion

    #region Roles

    #region RoleTable
    [Table("BD_Roles")]
    public class BD_Roles
    {
        [Key]
        public int RoleID { get; set; }
        [Display(Name = "Title")]
        [Required(ErrorMessage = "Enter Role Name")]
        [StringLength(100, ErrorMessage = "The {0} must be at least {2} characters long.", MinimumLength = 4)]
        public string Title { get; set; }
        [Display(Name = "Status")]
        [Required(ErrorMessage = "CHoose Status")]
        public char Status { get; set; }

        public IEnumerable<BD_Roles> bd_Roles { get; set; }
    }
    #endregion

    #region RoleInsert
    public class RoleInsert
    {
        #region Adduser
        public int AddNewRole(BD_Roles roles)
        {

            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("BD_Roles_Insert", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@Title", roles.Title);
            cmd.Parameters.AddWithValue("@Status", roles.Status);
            con.Open();
            int newID = Convert.ToInt32(cmd.ExecuteScalar());
            con.Close();
            if (newID >= 1)
            {
                return newID;
            }
            else
            {
                return 0;
            }
        }

        #endregion
        #region Viewuser
        public List<BD_Roles> GetRoles()
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<BD_Roles> MasterList = new List<BD_Roles>();
                SqlCommand com = new SqlCommand("BD_Roles_SelectAll", conn);
                com.CommandType = CommandType.StoredProcedure;
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    MasterList.Add(

                        new BD_Roles
                        {
                            RoleID = Convert.ToInt32(dr["RoleID"]),
                            Title = Convert.ToString(dr["Title"]),
                            Status = Convert.ToChar(dr["Status"]),
                        }
                    );
                }

                return MasterList;
            }
        }

        #endregion

        #region Edit User
        public List<BD_Roles> GetEditRole(int RoleID)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<BD_Roles> EmpList = new List<BD_Roles>();
                SqlCommand com = new SqlCommand("BD_Roles_SelectOne", conn);
                com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@RoleID", RoleID);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new BD_Roles
                        {
                            RoleID = Convert.ToInt32(dr["RoleID"]),
                            Title = Convert.ToString(dr["Title"]),
                            Status = Convert.ToChar(dr["Status"]),
                        }
                    );
                }

                return EmpList;
            }
        }
        #endregion

        #region Update User
        public bool UpdateRole(BD_Roles roles)
        {

            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("BD_Roles_Update", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@RoleID", roles.RoleID);
            cmd.Parameters.AddWithValue("@Title", roles.Title);
            cmd.Parameters.AddWithValue("@Status", roles.Status);
            con.Open();
            int i = cmd.ExecuteNonQuery();
            con.Close();
            if (i >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        #endregion

        #region Delete User
        public bool DeleteRoles(int RoleID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("RolesMaster_Delete", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@RoleID", RoleID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        #endregion

    }
    #endregion



    #endregion

    #region UserModules
    public class UserModulesMaster
    {
        public AdminLogin AdminMaster { get; set; }
        public BD_Roles RolesMaster { get; set; }
    }
    #endregion

    #region Icon Master Table

    #region Icon Table

    [Table("IconMaster")]
    public class IconMaster
    {
        [Key]
        public int IconID { get; set; }
        [Display(Name = "IconName")]
        [Required(ErrorMessage = "Please Enter Icon Name")]
        public string IconName { get; set; }
        [Display(Name = "ClassName")]
        [Required(ErrorMessage = "Please Enter Class Name")]
        public string ClassName { get; set; }
        [Display(Name = "Status")]
        [Required(ErrorMessage = "Please Select Status")]
        public string Status { get; set; }
        public int CreatedBy { get; set; }
        public DateTime CreatedDate = DateTime.UtcNow;
        public int ModifiedBy { get; set; }
        public DateTime ModifiedDate = DateTime.UtcNow;

        public IEnumerable<IconMaster> iconMasters { get; set; }
    }

    #endregion

    #region Icon Master Insert

    public class IconmasterInsert
    {
        public int AddNewIcon(IconMaster master)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("IconMaster_Insert", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@IconName", master.IconName);
            cmd.Parameters.AddWithValue("@ClassName", master.ClassName);
            cmd.Parameters.AddWithValue("@Status", master.Status);
            cmd.Parameters.AddWithValue("@CreatedBy", master.CreatedBy);
            cmd.Parameters.AddWithValue("@CreatedDate", master.CreatedDate);
            cmd.Parameters.AddWithValue("@ModifiedBy", master.ModifiedBy);
            cmd.Parameters.AddWithValue("@ModifiedDate", master.ModifiedDate);
            con.Open();
            int newID = Convert.ToInt32(cmd.ExecuteScalar());
            con.Close();
            if (newID >= 1)
            {
                return newID;
            }
            else
            {
                return 0;
            }
        }

        public List<IconMaster> GetIconMaster()
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<IconMaster> MasterList = new List<IconMaster>();
                SqlCommand com = new SqlCommand("GetAllIconmaster", conn);
                com.CommandType = CommandType.StoredProcedure;
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    MasterList.Add(

                        new IconMaster
                        {
                            IconID = Convert.ToInt32(dr["IconID"]),
                            IconName = Convert.ToString(dr["IconName"] == DBNull.Value ? null : dr["IconName"].ToString()),
                            ClassName = Convert.ToString(dr["ClassName"] == DBNull.Value ? null : dr["ClassName"].ToString()),
                            Status = Convert.ToString(dr["Status"] == DBNull.Value ? null : dr["Status"].ToString()),
                            CreatedBy = Convert.ToInt32(dr["CreatedBy"] == DBNull.Value ? null : dr["CreatedBy"].ToString()),
                            CreatedDate = Convert.ToDateTime(dr["CreatedDate"] == DBNull.Value ? null : dr["CreatedDate"].ToString()),
                            ModifiedBy = Convert.ToInt32(dr["ModifiedBy"] == DBNull.Value ? null : dr["ModifiedBy"].ToString()),
                            ModifiedDate = Convert.ToDateTime(dr["ModifiedDate"] == DBNull.Value ? null : dr["ModifiedDate"].ToString()),
                        }
                    );
                }

                return MasterList;
            }
        }

        public List<IconMaster> GetEditIconMaster(int IconID)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<IconMaster> EmpList = new List<IconMaster>();
                SqlCommand com = new SqlCommand("IconIDMaster_Edit", conn);
                com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@IconID", IconID);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new IconMaster
                        {
                            IconID = Convert.ToInt32(dr["IconID"]),
                            IconName = Convert.ToString(dr["IconName"]),
                            ClassName = Convert.ToString(dr["ClassName"]),
                            Status = Convert.ToString(dr["Status"]),
                            CreatedBy = Convert.ToInt32(dr["CreatedBy"] == DBNull.Value ? null : dr["CreatedBy"].ToString()),
                            CreatedDate = Convert.ToDateTime(dr["CreatedDate"] == DBNull.Value ? null : dr["CreatedDate"].ToString()),
                            ModifiedBy = Convert.ToInt32(dr["ModifiedBy"] == DBNull.Value ? null : dr["ModifiedBy"].ToString()),
                            ModifiedDate = Convert.ToDateTime(dr["ModifiedDate"] == DBNull.Value ? null : dr["ModifiedDate"].ToString())
                        }
                    );
                }

                return EmpList;
            }
        }

        public int UpdateIconMaster(IconMaster icon)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("IconMaster_Update", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@IconID", icon.IconID);
            cmd.Parameters.AddWithValue("@IconName", icon.IconName);
            cmd.Parameters.AddWithValue("@ClassName", icon.ClassName);
            cmd.Parameters.AddWithValue("@Status", icon.Status);
            cmd.Parameters.AddWithValue("@CreatedBy", icon.CreatedBy);
            cmd.Parameters.AddWithValue("@CreatedDate", icon.CreatedDate);
            cmd.Parameters.AddWithValue("@ModifiedBy", icon.ModifiedBy);
            cmd.Parameters.AddWithValue("@ModifiedDate", icon.ModifiedDate);
            con.Open();
            int newID = Convert.ToInt32(cmd.ExecuteScalar());
            con.Close();
            if (newID >= 1)
            {
                return newID;
            }
            else
            {
                return 0;
            }
        }
        public bool DeleteIconMaster(int IconID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("IconMaster_Delete", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@IconID", IconID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }



    }
    #endregion

    #endregion

    #region DomainMaster
    [Table("DomainMaster")]
    public class Domain
    {
        [Key]
        public int DomainID { get; set; }
        [Required]
        [Display(Name = "Domain Code")]
        public string DomainCode { get; set; }
        [Required]
        [Display(Name = "Domain Name")]
        public string DomainName { get; set; }
        //public int CompanyTypeID { get; set; }
        //public int TabOrder { get; set; }
        public int CreatedBy { get; set; }
        public DateTime CreatedDate = DateTime.UtcNow;
        public int ModifiedBy { get; set; }
        public DateTime ModifiedDate = DateTime.UtcNow;
    }

    public class DomainView
    {
        [Key]
        public int DomainID { get; set; }
        public string DomainCode { get; set; }
        public string DomainName { get; set; }
        public int TabOrder { get; set; }
        public string UserName { get; set; }
        public int CreatedBy { get; set; }
        public DateTime CreatedDate = DateTime.UtcNow;
        public int ModifiedBy { get; set; }
        public DateTime ModifiedDate = DateTime.UtcNow;

        public bool IsChecked { get; set; }

        public IEnumerable<DomainView> DomainViews { get; set; }
    }
    #endregion

    #region DomainInsert
    public class userType
    {
        public int AddDomain(Domain domain, int adminID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                //var CreatedBy = -1;
                //var ModifiedBy = -1;
                SqlCommand cmd = new SqlCommand("Domain_Insert", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@DomainCode", domain.DomainCode);
                cmd.Parameters.AddWithValue("@DomainName", domain.DomainName);
                cmd.Parameters.AddWithValue("@CreatedBy", adminID);
                cmd.Parameters.AddWithValue("@CreatedDate", domain.CreatedDate);
                cmd.Parameters.AddWithValue("@ModifiedBy", adminID);
                cmd.Parameters.AddWithValue("@ModifiedDate", domain.ModifiedDate);
                con.Open();
                int newID = Convert.ToInt32(cmd.ExecuteScalar());
                con.Close();
                if (newID >= 1)
                {
                    return newID;
                }
                else
                {
                    return 0;
                }
            }
        }

        public int AddModules(BD_Modules modules)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                int createdBy = -1;

                SqlCommand cmd = new SqlCommand("BD_Modules_Insert", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@DomainID", modules.DomainID);
                cmd.Parameters.AddWithValue("@IconID", modules.IconID);
                cmd.Parameters.AddWithValue("@ParentModuleID", modules.ParentModuleID);
                cmd.Parameters.AddWithValue("@ModuleName", modules.ModuleName);
                cmd.Parameters.AddWithValue("@Url", modules.Url);
                cmd.Parameters.AddWithValue("@Status", modules.Status);
                cmd.Parameters.AddWithValue("@CreatedBy", createdBy);
                cmd.Parameters.AddWithValue("@CreatedDate", modules.CreatedDate);
                cmd.Parameters.AddWithValue("@ModifiedBy", createdBy);
                cmd.Parameters.AddWithValue("@ModifiedDate", modules.ModifiedDate);
                con.Open();
                int newID = Convert.ToInt32(cmd.ExecuteScalar());
                con.Close();
                if (newID >= 1)
                {
                    return newID;
                }
                else
                {
                    return 0;
                }
            }
        }

        public List<DomainView> GetDomainViews()
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<DomainView> EmpList = new List<DomainView>();
                SqlCommand com = new SqlCommand("GetFullDomain", conn);
                com.CommandType = CommandType.StoredProcedure;
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new DomainView
                        {
                            DomainID = Convert.ToInt32(dr["DomainID"]),
                            DomainCode = Convert.ToString(dr["DomainCode"]),
                            DomainName = Convert.ToString(dr["DomainName"]),
                            CreatedDate = Convert.ToDateTime(dr["CreatedDate"] == DBNull.Value ? null : dr["CreatedDate"].ToString())
                        }
                    );
                }

                return EmpList;
            }
        }

        public List<Domain> GetEditDomain(int DomainID)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<Domain> EmpList = new List<Domain>();
                SqlCommand com = new SqlCommand("DomainMaster_Edit", conn);
                com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@DomainID", DomainID);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new Domain
                        {
                            DomainID = Convert.ToInt32(dr["DomainID"]),
                            DomainCode = Convert.ToString(dr["DomainCode"]),
                            DomainName = Convert.ToString(dr["DomainName"]),
                            CreatedBy = Convert.ToInt32(dr["CreatedBy"] == DBNull.Value ? null : dr["CreatedBy"].ToString()),
                            CreatedDate = Convert.ToDateTime(dr["CreatedDate"] == DBNull.Value ? null : dr["CreatedDate"].ToString()),
                            ModifiedBy = Convert.ToInt32(dr["ModifiedBy"] == DBNull.Value ? null : dr["ModifiedBy"].ToString()),
                            ModifiedDate = Convert.ToDateTime(dr["ModifiedDate"] == DBNull.Value ? null : dr["ModifiedDate"].ToString())
                        }
                    );
                }

                return EmpList;
            }
        }

        public bool UpdateDomain(Domain icon)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("DomainMaster_Update", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@DomainID", icon.DomainID);
            cmd.Parameters.AddWithValue("@DomainCode", icon.DomainCode);
            cmd.Parameters.AddWithValue("@DomainName", icon.DomainName);
            cmd.Parameters.AddWithValue("@CreatedBy", icon.CreatedBy);
            cmd.Parameters.AddWithValue("@CreatedDate", icon.CreatedDate);
            cmd.Parameters.AddWithValue("@ModifiedBy", icon.ModifiedBy);
            cmd.Parameters.AddWithValue("@ModifiedDate", icon.ModifiedDate);
            con.Open();
            int i = cmd.ExecuteNonQuery();
            con.Close();
            if (i >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public bool DeleteDomain(int DomainID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("DomainMaster_Delete", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@DomainID", DomainID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }

        public List<ViewRoleModules> GetRoleModulesViews()
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<ViewRoleModules> EmpList = new List<ViewRoleModules>();
                SqlCommand com = new SqlCommand("BD_Modules_SelectDomainModules", conn);
                com.CommandType = CommandType.StoredProcedure;
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new ViewRoleModules
                        {
                            ModuleID = Convert.ToInt32(dr["ModuleID"]),
                            DomainID = Convert.ToInt32(dr["DomainID"]),
                            ParentModuleID = Convert.ToInt32(dr["ParentModuleID"]),
                            IconID = Convert.ToInt32(dr["IconID"]),
                            ModuleName = Convert.ToString(dr["ModuleName"]),
                            Url = Convert.ToString(dr["Url"]),
                            Status = Convert.ToString(dr["Status"]),
                            CreatedBy = Convert.ToInt32(dr["CreatedBy"] == DBNull.Value ? null : dr["CreatedBy"].ToString()),
                            CreatedDate = Convert.ToDateTime(dr["CreatedDate"]),
                            ModifiedBy = Convert.ToInt32(dr["ModifiedBy"] == DBNull.Value ? null : dr["ModifiedBy"].ToString()),
                            ModifiedDate = Convert.ToDateTime(dr["ModifiedDate"] == DBNull.Value ? null : dr["ModifiedDate"].ToString())
                        }
                    );
                }

                return EmpList;
            }
        }

        public List<ViewRoleModules> GetEditRoleModulesViews(int id)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<ViewRoleModules> EmpList = new List<ViewRoleModules>();
                SqlCommand com = new SqlCommand("BD_Modules_SelectDomainEditModules", conn);
                com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@ModuleID", id);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new ViewRoleModules
                        {
                            ModuleID = Convert.ToInt32(dr["ModuleID"]),
                            DomainID = Convert.ToInt32(dr["DomainID"]),
                            IconID = Convert.ToInt32(dr["IconID"]),
                            ParentModuleID = Convert.ToInt32(dr["ParentModuleID"]),
                            ModuleName = Convert.ToString(dr["ModuleName"]),
                            Url = Convert.ToString(dr["Url"]),
                            Status = Convert.ToString(dr["Status"]),
                            CreatedBy = Convert.ToInt32(dr["CreatedBy"] == DBNull.Value ? null : dr["CreatedBy"].ToString()),
                            CreatedDate = Convert.ToDateTime(dr["CreatedDate"]),
                            ModifiedBy = Convert.ToInt32(dr["ModifiedBy"] == DBNull.Value ? null : dr["ModifiedBy"].ToString()),
                            ModifiedDate = Convert.ToDateTime(dr["ModifiedDate"] == DBNull.Value ? null : dr["ModifiedDate"].ToString())
                        }
                    );
                }

                return EmpList;
            }
        }

        public List<ViewRoleModules> GetSiteRoleModulesViews(int rid)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<ViewRoleModules> RoleList = new List<ViewRoleModules>();
                SqlCommand com = new SqlCommand("BD_SiteRoleModules_SelectOne", conn);
                com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@ModuleID", rid);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    RoleList.Add(

                        new ViewRoleModules
                        {
                            //RoleID = Convert.ToInt32(dr["RoleID"]),
                            RoleName = Convert.ToString(dr["RoleName"]),
                            //*****Included ModuleID Here*****
                            ModuleID = rid,
                        }
                    );
                }

                return RoleList;
            }
        }

        #region Delete SiteRole Modules
        public bool deleteSiteRoleModules(int ModuleID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("Modules_DeleteSiteRoleModules", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@ModuleID", ModuleID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        #endregion

        #region Repeate Site RoleModules
        public bool SaveSiteRoleModule(int ModuleID, int RoleID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("BD_SiteRoleModules_Update", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@ModuleID", ModuleID);
                //cmd.Parameters.AddWithValue("@ModuleID", modulesID);
                cmd.Parameters.AddWithValue("@RoleID", RoleID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        #endregion
        public bool DeleteModuleModule(int ModuleID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("Modules_Delete", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@ModuleID", ModuleID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }


    }


    #endregion

    #region ModulesMaster

    [Table("BD_Modules")]
    public class BD_Modules
    {
        [Key]
        public int ModuleID { get; set; }
        [Display(Name = "DomainID")]
        [Required(ErrorMessage = "Choose Domain Name")]
        public int DomainID { get; set; }
        public int ParentModuleID { get; set; }
        public int IconID { get; set; }
        [Display(Name = "ModuleName")]
        [Required(ErrorMessage = "Enter Module Name")]
        public string ModuleName { get; set; }
        [Display(Name = "Url")]
        [Required(ErrorMessage = "Enter Url")]
        public string Url { get; set; }
        public char Status { get; set; }
        public int CreatedBy { get; set; }
        public DateTime CreatedDate = DateTime.UtcNow;
        public int ModifiedBy { get; set; }
        public DateTime ModifiedDate = DateTime.UtcNow;

        public List<RoleModel> roles { get; set; }



        #region Update Modules
        public bool UpdateModules(int ModuleID, int DomainID, int ParentModuleID, int IconID, string ModuleName, string Url, string Status)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
            SqlCommand cmd = new SqlCommand("BD_Modules_Update", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@ModuleID", ModuleID);
            cmd.Parameters.AddWithValue("@DomainID", DomainID);
            cmd.Parameters.AddWithValue("@ParentModuleID", ParentModuleID);
            cmd.Parameters.AddWithValue("@IconID", IconID);
            cmd.Parameters.AddWithValue("@ModuleName", ModuleName);
            cmd.Parameters.AddWithValue("@Url", Url);
            cmd.Parameters.AddWithValue("@Status", Status);
            cmd.Parameters.AddWithValue("@CreatedBy", CreatedBy);
            cmd.Parameters.AddWithValue("@CreatedDate", CreatedDate);
            cmd.Parameters.AddWithValue("@ModifiedBy", ModifiedBy);
            cmd.Parameters.AddWithValue("@ModifiedDate", ModifiedDate);
            con.Open();
            int i = cmd.ExecuteNonQuery();
            con.Close();
            if (i >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        #endregion
    }

    public class RoleModel
    {
        [Key]
        public int RoleID { get; set; }
        public string RoleName { get; set; }
        public bool IsChecked { get; set; }

        public IEnumerable<RoleModel> roles { get; set; }

    }

    public class ViewRoleModules
    {
        [Key]
        public int ModuleID { get; set; }
        public int DomainID { get; set; }
        public int ParentModuleID { get; set; }
        public int IconID { get; set; }
        public string ModuleName { get; set; }
        public string Url { get; set; }
        public string Status { get; set; }
        public int CreatedBy { get; set; }
        public DateTime CreatedDate = DateTime.UtcNow;
        public int ModifiedBy { get; set; }
        public DateTime ModifiedDate = DateTime.UtcNow;

        public string DomainName { get; set; }
        public string RoleName { get; set; }
        public int RoleID { get; set; }

        public bool IsChecked { get; set; }

        public List<RoleModel> rolesEdit { get; set; }

        public IEnumerable<ViewRoleModules> ModuleViews { get; set; }
        public IEnumerable<ViewRoleModules> ChildModuleViews { get; set; }
    }


    [Table("SiteRoleModules")]
    public class SiteRoleModules
    {
        [Key]
        public int RoleID { get; set; }
        [Key]
        public int ModuleID { get; set; }

        public bool AddSiteRoleModules()
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("BD_SiteRoleModules_Insert", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@RoleID", RoleID);
                cmd.Parameters.AddWithValue("@ModuleID", ModuleID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
    }

    #endregion

    #region UserModulesBind
    public class UserModulesBind
    {
        #region get Role ModulesView
        public List<BD_Modules> GetRoleModulesViews()
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<BD_Modules> EmpList = new List<BD_Modules>();
                SqlCommand com = new SqlCommand("Select * From BD_Modules", conn);
                //com.CommandType = CommandType.StoredProcedure;
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new BD_Modules
                        {
                            ModuleID = Convert.ToInt32(dr["ModuleID"]),
                            DomainID = Convert.ToInt32(dr["DomainID"]),
                            ParentModuleID = Convert.ToInt32(dr["ParentModuleID"]),
                            IconID = Convert.ToInt32(dr["IconID"]),
                            ModuleName = Convert.ToString(dr["ModuleName"]),
                            Url = Convert.ToString(dr["Url"])
                        }
                    );
                }

                return EmpList;
            }
        }
        #endregion

        #region getModulesView
        public List<BD_Modules> GetModulesViews(int AdminID)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<BD_Modules> EmpList = new List<BD_Modules>();
                SqlCommand com = new SqlCommand("Select * From UserModules where AdminID=@AdminID", conn);
                //com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@AdminID", AdminID);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new BD_Modules
                        {
                            ModuleID = Convert.ToInt32(dr["ModuleID"]),
                        }
                    );
                }

                return EmpList;
            }
        }
        #endregion


        #region Repeate Module And Submodule Save
        public bool SaveUserModule(int adminID, int roleID, int ModulesID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("AssignUserModules_Insert", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@AdminID", adminID);
                cmd.Parameters.AddWithValue("@RoleID", roleID);
                cmd.Parameters.AddWithValue("@ModuleID", ModulesID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        #endregion


        #region Delete User Modules
        public bool deleteUserModules(int AdminID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("UserModules_Delete", con);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.AddWithValue("@AdminID", AdminID);
                con.Open();
                int i = cmd.ExecuteNonQuery();
                con.Close();
                if (i >= 1)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        #endregion

    }
    #endregion



    #region Rolelist
    public class Rolelist
    {
        public DataSet Get_Roles()
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                SqlCommand cmd = new SqlCommand("Select * From BD_Roles", con);
                SqlDataAdapter da = new SqlDataAdapter(cmd);
                DataSet ds = new DataSet();
                da.Fill(ds);
                return ds;
            }

        }

        #region get Edition ModulesView
        public List<RoleModel> GetModules_Roles(int ModuleID)
        {
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {
                List<RoleModel> EmpList = new List<RoleModel>();
                SqlCommand com = new SqlCommand("SiteRoleModules_SelectOne", conn);
                com.CommandType = CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@ModuleID", ModuleID);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataTable dt = new DataTable();

                conn.Open();
                da.Fill(dt);
                conn.Close();
                foreach (DataRow dr in dt.Rows)
                {

                    EmpList.Add(

                        new RoleModel
                        {
                            RoleID = Convert.ToInt32(dr["RoleID"]),
                        }
                    );
                }

                return EmpList;
            }
        }
        #endregion
    }

    #endregion

    #region CheckUserName
    public class checkusername
    {
        public int CheckUserNameAvailability(string UserName)
        {
            string conString = ConfigurationManager.ConnectionStrings["Admin"].ConnectionString;
            using (SqlConnection conn = new SqlConnection(conString))
            {
                using (SqlCommand cmd = new SqlCommand("spCheckUserNameAvailability", conn))
                {
                    cmd.CommandType = CommandType.StoredProcedure;
                    cmd.Parameters.AddWithValue("@UserName", UserName);
                    conn.Open();
                    return (int)cmd.ExecuteScalar();
                }
            }
        }
    }
    #endregion

    #region Domain
    public class DomainBind
    {
        #region Get Domain
        // Get All Country
        SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
        public DataSet Domain_Bind()
        {
            SqlCommand cmd = new SqlCommand("Select * From DomainMaster", con);
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            DataSet ds = new DataSet();
            da.Fill(ds);
            return ds;
        }

        public DataSet EditParentModule_Bind(string DomainID, string ParentModuleID)
        {
            using (SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString))
            {

                SqlCommand com = new SqlCommand("Select *,(select ModuleName from BD_Modules where ModuleID = @ParentModuleID )  as Submodule1 from BD_Modules where DomainID=@DomainID AND ParentModuleID=@ParentModuleID", con);
                com.Parameters.AddWithValue("@DomainID", DomainID);
                com.Parameters.AddWithValue("@ParentModuleID", ParentModuleID);
                SqlDataAdapter da = new SqlDataAdapter(com);
                DataSet ds = new DataSet();
                da.Fill(ds);
                return ds;
            }
        }

        #endregion
    }
    #endregion

    #region Admin Bind
    #region Get Admin
    public class AdminBind
    {
        // Get All Country
        SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
        public DataSet Admin_Bind()
        {
            SqlCommand cmd = new SqlCommand("Select * From AdminLogin", conn);
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            DataSet ds = new DataSet();
            da.Fill(ds);
            return ds;
        }
    }
    #endregion
    #endregion

    #region Get Role
    public class RoleBind
    {
        // Get All Country
        SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
        public DataSet Role_Bind()
        {
            SqlCommand cmd = new SqlCommand("Select * From BD_Roles", conn);
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            DataSet ds = new DataSet();
            da.Fill(ds);
            return ds;
        }
    }
    #endregion


    #region ParentModule_Bind
    public class ParentModule
    {
        SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["Admin"].ConnectionString);
        public DataSet ParentModule_Bind(string DomainID)
        {
            SqlCommand cmd = new SqlCommand("Select * From BD_Modules where DomainID=@DomainID  ", con);
            cmd.Parameters.AddWithValue("@DomainID", DomainID);
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            DataSet ds = new DataSet();
            da.Fill(ds);
            return ds;
        }
        public DataSet Get_Icon()
        {
            SqlCommand cmd = new SqlCommand("Select * From IconMaster", con);
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            DataSet ds = new DataSet();
            da.Fill(ds);
            return ds;
        }
    }

    #endregion
}