﻿using CRM_MVC.Models;
using MedeilClouD.Filters;
using System;
using System.Collections.Generic;
using System.Data;
using System.Dynamic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Security;

namespace CRM_MVC.Controllers
{
    public class AccountController : Controller
    {
        //
        // GET: /Account/
        public ActionResult Index()
        {
            return View();
        }

        #region Login
        [HttpGet]
        [AllowAnonymous]
        public ActionResult Login()
        {
            return View();
        }

        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult Login(Login login)
        {
            if (ModelState.IsValid)
            {
                checkuser user = new checkuser();
                bool success = user.checkUserDetails(login);
                var AdminID = GetUserID_By_UserName(login.UserName);
                var isActive = GetUserID_By_IsActive(login.UserName);
                if (success == true)
                {
                    if (Convert.ToInt32(AdminID) > 0)
                    {
                        if (isActive == "Y")
                        {
                            var menu = user.LoadPagePermissions(Convert.ToInt32(AdminID));
                            Session["MenuMaster"] = menu;
                            Session["Name"] = login.UserName;
                            Session["AdminID"] = AdminID;
                            FormsAuthentication.SetAuthCookie(login.UserName, false);
                            return RedirectToAction("Index", "Home");
                        }
                    }
                    else
                    {
                        ModelState.AddModelError(string.Empty, "UserName or Password is incorrect");
                        return View(login);
                    }
                }
            }
            return View(login);
        }
        #endregion

        #region Logout
        //
        // POST: /Account/LogOff
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult LogOff()
        {
            return RedirectToAction("Login", "Account");
        }
        #endregion

        #region AdminUser

        #region AddUser
        [Authorize]
        [MyExceptionHandler]
        public ActionResult AddUser()
        {
            return View();
        }

        [HttpPost]
        [AllowAnonymous]
        [MyExceptionHandler]
        [ValidateAntiForgeryToken]
        public ActionResult AddUser(AdminLogin admin)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    AddNewUser user = new AddNewUser();
                    var adminId = Session["AdminID"];
                    int uID = user.AddNewUserReg(admin, Convert.ToInt32(adminId));
                    if (uID > 0)
                    {
                        return RedirectToAction("ViewUser", "Account");
                    }
                }
                return View();
            }
            catch
            {
                return View();
            }
        }

        #endregion

        #region ViewUser
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]

        public ActionResult ViewUser()
        {
            dynamic mymodel = new ExpandoObject();
            AddNewUser user = new AddNewUser();
            mymodel.adminLogin = user.GetUser();
            return View(mymodel);
        }
        #endregion

        #region Edit User
        public ActionResult EditUser(int AdminID)
        {
            AddNewUser user = new AddNewUser();
            var pID = user.GetEditUser(AdminID).Find(Emp => Emp.AdminID == AdminID);
            return View(pID);
        }

        [HttpPost]
        public ActionResult EditUser(AdminLogin admin)
        {
            try
            {
                AddNewUser user = new AddNewUser();
                bool suc = user.UpdateUser(admin);
                if (suc == true)
                {
                    return RedirectToAction("ViewUser", "Account");
                }
                return View();
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #region Delete UserMaster
        [HttpPost]
        public ActionResult DeleteUserMaster(int AdminID)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    AddNewUser user = new AddNewUser();
                    user.DeleteUserMaster(AdminID);
                }
                return Json(new { success = true, message = "Deleted successfully" }, JsonRequestBehavior.AllowGet);
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #endregion

        #region Roles

        #region AddRoles
        [Authorize]
        [MyExceptionHandler]
        public ActionResult AddRoles()
        {
            return View();
        }
        
        [HttpPost]
        [Authorize]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult AddRoles(BD_Roles roles)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    RoleInsert role = new RoleInsert();
                    
                    int uID = role.AddNewRole(roles);
                    if (uID > 0)
                    {
                        return RedirectToAction("ViewRoles", "Account");
                    }
                }
                return View();
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #region ViewRoles
        public ActionResult ViewRoles()
        {
            dynamic mymodel = new ExpandoObject();
            RoleInsert role = new RoleInsert();
            mymodel.bd_Roles = role.GetRoles();
            return View(mymodel);
        }
        #endregion

        #region EditRoles
        public ActionResult EditRoles(int RoleID)
        {
            RoleInsert role = new RoleInsert();
            var pID = role.GetEditRole(RoleID).Find(Emp => Emp.RoleID == RoleID);
            return View(pID);
        }

        [HttpPost]
        public ActionResult EditRoles(BD_Roles roles)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    RoleInsert role = new RoleInsert();
                    bool suc = role.UpdateRole(roles);
                    if (suc == true)
                    {
                        return RedirectToAction("ViewRoles", "Account");
                    }
                }
                return View();
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #region Delete Roles
        [HttpPost]
        public ActionResult DeleteRole(int RoleID)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    RoleInsert role = new RoleInsert();
                    role.DeleteRoles(RoleID);
                }
                return Json(new { success = true, message = "Deleted successfully" }, JsonRequestBehavior.AllowGet);
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #endregion

        #region Icon Master

        #region Add Icon
        [Authorize]
        [MyExceptionHandler]
        public ActionResult AddIcon()
        {
            return View();
        }

        [HttpPost]
        [Authorize]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult AddIcon(IconMaster master)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    IconmasterInsert icoN = new IconmasterInsert();
                    int ID = icoN.AddNewIcon(master);
                    if (ID != 0)
                    {
                        ViewBag.Message = "Icon added successfully";
                        return RedirectToAction("ViewIcon", "Account");
                    }
                }
                return View();
            }
            catch
            {
                return View();
            }
        }

        #endregion

        #region View Icon
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]
        public ActionResult ViewIcon()
        {
            dynamic mymodel = new ExpandoObject();
            IconmasterInsert mas = new IconmasterInsert();
            mymodel.iconMasters = mas.GetIconMaster();
            return View(mymodel);

        }
        #endregion

        #region Edit IconMaster
        public ActionResult EditIconMaster(int IconID)
        {
            IconmasterInsert mastr = new IconmasterInsert();
            var pID = mastr.GetEditIconMaster(IconID).Find(Emp => Emp.IconID == IconID);
            return View(pID);
        }

        [HttpPost]
        public ActionResult EditIconMaster(IconMaster master)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    IconmasterInsert mastr = new IconmasterInsert();
                    mastr.UpdateIconMaster(master);
                }
                return RedirectToAction("ViewIcon", "Account");
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #region Delete IconMaster
        [HttpPost]
        public ActionResult DeleteIconMaster(int IconID)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    IconmasterInsert mastr = new IconmasterInsert();
                    mastr.DeleteIconMaster(IconID);
                }
                return Json(new { success = true, message = "Deleted successfully" }, JsonRequestBehavior.AllowGet);
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #endregion


        #region Domain

        #region Domain Master
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]
        public ActionResult Domain()
        {
            return View();
        }


        [HttpPost]
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]
        [ValidateAntiForgeryToken]
        public ActionResult Domain(Domain domain)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    userType type = new userType();
                    var adminID = Session["AdminID"];
                    int id = type.AddDomain(domain,Convert.ToInt32(adminID));
                    if (id != 0)
                    {
                        Session["returnID"] = id.ToString();
                        ViewBag.Message = "Domain added successfully";
                        return RedirectToAction("ViewDomain", "Account");
                    }
                }
                return View();
            }
            catch
            {
                return View();
            }

        }
        #endregion

        #region View Domain
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]
        public ActionResult ViewDomain()
        {
            dynamic mymodel = new ExpandoObject();
            userType type = new userType();
            mymodel.DomainViews = type.GetDomainViews();
            return View(mymodel);

        }

        #endregion

        #region Edit Domain
        public ActionResult EditDomain(int DomainID)
        {
            userType mastr = new userType();
            var pID = mastr.GetEditDomain(DomainID).Find(Emp => Emp.DomainID == DomainID);
            return View(pID);
        }

        [HttpPost]
        public ActionResult EditDomain(Domain master)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    userType mastr = new userType();
                    mastr.UpdateDomain(master);
                }
                return RedirectToAction("ViewDomain", "Account");
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #region Delete Domain
        [HttpPost]
        public ActionResult DeleteDomain(int DomainID)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    userType mastr = new userType();
                    mastr.DeleteDomain(DomainID);
                }
                return Json(new { success = true, message = "Deleted successfully" }, JsonRequestBehavior.AllowGet);
            }
            catch
            {
                return View();
            }
        }
        #endregion

        #endregion

        #region Modules

        #region Add Modules
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]
        public ActionResult AddModules()
        {
            Domain_Bind();
            Icon_BInd();
            Rolelist type = new Rolelist();
            DataSet ds = type.Get_Roles();
            List<RoleModel> RolesList = new List<RoleModel>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                RolesList.Add(new RoleModel { RoleName = dr["Title"].ToString(), RoleID = Convert.ToInt32(dr["RoleID"]) });
            }
            BD_Modules objBind = new BD_Modules();
            objBind.roles = RolesList;
            return View(objBind);
        }

        [HttpPost]
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]
        [ValidateAntiForgeryToken]
        public ActionResult AddModules(BD_Modules modules)
        {
            Domain_Bind();
            Icon_BInd();
            userType type = new userType();
            if (ModelState.IsValid)
            {
                int modID = type.AddModules(modules);
                SiteRoleModules SiteRole = new SiteRoleModules();
                SiteRole.ModuleID = modID;
                string RoleIDs = selectRepeaterItems(modules.roles);
                if (modID != 0)
                {
                    foreach (var rid in RoleIDs.Split(','))
                    {
                        string RID = rid;
                        SiteRole.RoleID = Convert.ToInt32(RID);
                        if (SiteRole.AddSiteRoleModules())
                        {
                        }
                    }
                }
            }
            return RedirectToAction("ViewModules", "Account");
        }
        #endregion

        #region ViewModules
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]
        public ActionResult ViewModules()
        {
            return View();
        }

        [HttpPost]
        public ActionResult ViewModulesDetails()
        {
            //dynamic mymodel = new ExpandoObject();
            userType type = new userType();
            List<ViewRoleModules> EmpList = type.GetRoleModulesViews();
            List<ViewRoleModules> RoleList;
            List<ViewRoleModules> role = new List<ViewRoleModules>();
            foreach (ViewRoleModules emp in EmpList)
            {
                RoleList = type.GetSiteRoleModulesViews(emp.ModuleID);
                foreach (ViewRoleModules vip in RoleList)
                {
                    role.Add(new ViewRoleModules
                    {
                        RoleName = vip.RoleName,
                        ModuleID = vip.ModuleID
                    });
                }
            }

            var data = new { EmpList = EmpList, role = role };

            return Json(data, JsonRequestBehavior.AllowGet);
        }
        #endregion

        #region Edit Modules
        public ActionResult EditModules(int id)
        {
            EditDomain_Bind();
            userType type = new userType();
            var ModID = type.GetEditRoleModulesViews(id).Find(Emp => Emp.ModuleID == id);
            int domainID = ModID.DomainID;
            AccountContext db = new AccountContext();
            string selected = (from sub in db.domain
                               where sub.DomainID == domainID
                               select sub.DomainID.ToString()).First();
            ViewBag.DomainID = new SelectList(db.domain, "DomainID", "DomainName", selected);

            AccountContext account = new AccountContext();
            int iconID = ModID.IconID;
            string icon = (from sub in account.iconMaster
                           where sub.IconID == iconID
                           select sub.IconID.ToString()).First();
            ViewBag.IconID = new SelectList(account.iconMaster, "IconID", "IconName", icon);
            return View(ModID);
        }
        #endregion

        #region Update ModulesMaster
        [HttpPost]
        public ActionResult UpdateModules(int ModuleID, int DomainID, int ParentModuleID, int IconID, string ModuleName,string Url,string Status, List<int> RoleID)
        {
            userType deletesite = new userType();
            deletesite.deleteSiteRoleModules(ModuleID);
            BD_Modules modules = new BD_Modules();
            modules.UpdateModules(ModuleID, DomainID, ParentModuleID, IconID, ModuleName, Url, Status);
            UpdateRepeaterUserModulesItems(ModuleID, RoleID);
            return Json(new { success = true, message = "Added successfully" }, JsonRequestBehavior.AllowGet);
        }
        #endregion

        #region Update REPEATER VALUES
        public void UpdateRepeaterUserModulesItems(int ModuleID, List<int> RoleID)
        {
            for (int j = 0; j < RoleID.Count; j++)
            {
                int roleID = RoleID[j];
                userType deletesite = new userType();
                deletesite.SaveSiteRoleModule(ModuleID, roleID);

            }
        }
        #endregion

        #region Delete Module
        [HttpPost]
        public ActionResult DeleteModule(int ModuleID)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    userType type = new userType();
                    type.DeleteModuleModule(ModuleID);
                }
                return Json(new { success = true, message = "updated successfully" }, JsonRequestBehavior.AllowGet);
            }
            catch
            {
                return View();
            }

        }

        #endregion


        #region User Modules
        [Authorize]
        [AllowAnonymous]
        [MyExceptionHandler]
        public ActionResult UserModules()
        {
            Admin_Bind();
            Role_Bind();
            return View();
        }

        [HttpPost]
        public ActionResult CreateUserModules(int AdminID, int RoleID, List<int> ModuleID)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    UserModulesBind userM = new UserModulesBind();
                    userM.deleteUserModules(AdminID);
                    SaveRepeaterUserRolesItems(AdminID, RoleID, ModuleID);
                }
                return Json(new { success = true, message = "Added successfully" }, JsonRequestBehavior.AllowGet);
            }
            catch(Exception ex)
            {
                return View();
            }
        }

        #region SELECT REPEATER Role VALUES
        public void SaveRepeaterUserRolesItems(int AdminID, int RoleID, List<int> ModuleID)
        {
            //int r = 0;
            //for (int i = 0; i < ModuleID.Count; i++)
            //{
            //    int modulesID = ModuleID[i];
            for (int j = 0; j < ModuleID.Count; j++)
            {
                int mduleosID = ModuleID[j];
                UserModulesBind userM = new UserModulesBind();
                userM.SaveUserModule(AdminID, RoleID, mduleosID);

            }
            // }

        }
        #endregion

        #region BindViewModule
        public ActionResult BindViewModuleAccess()
        {
            UserModulesBind userM = new UserModulesBind();
            List<BD_Modules> modulesList = userM.GetRoleModulesViews();
            return Json(modulesList, JsonRequestBehavior.AllowGet);
        }
        #endregion

        #region BindViewModule
        public ActionResult BindViewModule( int AdminID)
        {
            UserModulesBind userM = new UserModulesBind();
            List<BD_Modules> modulesList = userM.GetModulesViews(AdminID);
            return Json(modulesList, JsonRequestBehavior.AllowGet);
        }
        #endregion
        #endregion

        #region CheckBoxDetails
        public ActionResult EditRoleModules_Bind()
        {
            Rolelist type = new Rolelist();
            DataSet ds = type.Get_Roles();
            List<RoleModel> RolesList = new List<RoleModel>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                RolesList.Add(new RoleModel { RoleName = dr["Title"].ToString(), RoleID = Convert.ToInt32(dr["RoleID"]) });
            }
            BD_Modules objBind = new BD_Modules();
            objBind.roles = RolesList;
            var data = new { RoleList = RolesList };
            return Json(data, JsonRequestBehavior.AllowGet);
        }
        #endregion

        #region CheckBox Checked
        [HttpPost]
        public ActionResult BindEditRoleModules(int ModuleID)
        {
            Rolelist role = new Rolelist();
            List<RoleModel> RolesList = role.GetModules_Roles(ModuleID);
            BD_Modules objBind = new BD_Modules();
            objBind.roles = RolesList;
            var data = new { RoleList = RolesList };
            return Json(data, JsonRequestBehavior.AllowGet);
        }
        #endregion

        #endregion

        #region Get selected CheckBox Lists for save
        public static string selectRepeaterItems(List<RoleModel> role)
        {
            string sRepeaterIDs = string.Empty;
            foreach (RoleModel lItem in role)
            {
                if (lItem.IsChecked)
                    sRepeaterIDs += lItem.RoleID + ",";
            }
            if (sRepeaterIDs != "")
            {
                sRepeaterIDs = sRepeaterIDs.Remove(sRepeaterIDs.Length - 1, 1);
                return sRepeaterIDs;
            }
            else
                return "";
        }
        #endregion

        #region CheckUserName
        [HttpPost]
        public ActionResult CheckUserNameAvailability(string UserName)
        {
            checkusername check = new checkusername();
            int id = check.CheckUserNameAvailability(UserName);
            if (id != 0)
            {
                return Json(new { id = id });
            }
            return View();
        }
        #endregion

        #region Domain Bind
        public void Domain_Bind()
        {
            DomainBind domain = new DomainBind();
            DataSet ds = domain.Domain_Bind();
            List<SelectListItem> domainlist = new List<SelectListItem>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                domainlist.Add(new SelectListItem { Text = dr["DomainName"].ToString(), Value = dr["DomainID"].ToString() });
            }
            ViewBag.DomainID = domainlist;
        }

        public void EditDomain_Bind()
        {
            DomainBind domain = new DomainBind();
            DataSet ds = domain.Domain_Bind();
            List<SelectListItem> domainlist = new List<SelectListItem>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                domainlist.Add(new SelectListItem { Text = dr["DomainName"].ToString(), Value = dr["DomainID"].ToString() });
            }
            ViewBag.DomainID = domainlist;
        }

        public JsonResult EditParentModule_Bind(string DomainID, string ParentModuleID)
        {
            DomainBind domain = new DomainBind();
            DataSet ds = domain.EditParentModule_Bind(DomainID, ParentModuleID);
            List<SelectListItem> productList = new List<SelectListItem>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                productList.Add(new SelectListItem { Text = dr["Submodule1"].ToString(), Value = dr["ParentModuleID"].ToString() });
            }
            return Json(productList, JsonRequestBehavior.AllowGet);
        }
        #endregion

        #region ParentModule_Bind
        public JsonResult ParentModule_Bind(string DomainID)
        {
            ParentModule product = new ParentModule();
            DataSet ds = product.ParentModule_Bind(DomainID);
            List<SelectListItem> productList = new List<SelectListItem>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                productList.Add(new SelectListItem { Text = dr["ModuleName"].ToString(), Value = dr["ModuleID"].ToString() });
            }
            return Json(productList, JsonRequestBehavior.AllowGet);
        }

        #endregion

        #region  Icon BInd
        public void Icon_BInd()
        {
            ParentModule country = new ParentModule();
            DataSet ds = country.Get_Icon();
            List<SelectListItem> IconList = new List<SelectListItem>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                IconList.Add(new SelectListItem { Text = dr["IconName"].ToString(), Value = dr["IconID"].ToString() });
            }
            ViewBag.IconID = IconList;
        }
        #endregion


        #region Admin Bind
        public void Admin_Bind()
        {
            AdminBind admin = new AdminBind();
            DataSet ds = admin.Admin_Bind();
            List<SelectListItem> adminlist = new List<SelectListItem>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                adminlist.Add(new SelectListItem { Text = dr["UserName"].ToString(), Value = dr["AdminID"].ToString() });
            }
            ViewBag.AdminID = adminlist;
        }
        #endregion


        #region Admin Bind
        public void Role_Bind()
        {
            RoleBind role = new RoleBind();
            DataSet ds = role.Role_Bind();
            List<SelectListItem> roleList = new List<SelectListItem>();
            foreach (DataRow dr in ds.Tables[0].Rows)
            {
                roleList.Add(new SelectListItem { Text = dr["Title"].ToString(), Value = dr["RoleID"].ToString() });
            }
            ViewBag.RoleID = roleList;
        }
        #endregion

        #region GetuserID_By_UserName
        [NonAction]
        public string GetUserID_By_UserName(string UserName)
        {
            checkuser user = new checkuser();
            return user.GetUserID_By_UserName(UserName);

        }
        #endregion

        #region GetuserID_By_UserNameIsActive
        [NonAction]
        public string GetUserID_By_IsActive(string UserName)
        {
            checkuser user = new checkuser();
            return user.GetUserID_By_IsActive(UserName);
        }
        #endregion
    }
}